<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user is logged in
requireLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    if (!isset($_GET['id']) || empty($_GET['id'])) {
        throw new Exception('Quotation ID is required');
    }
    
    $quotation_id = intval($_GET['id']);
    
    // Get quotation details
    $stmt = $pdo->prepare("
        SELECT 
            q.*,
            c.name as customer_name,
            c.phone as customer_phone,
            c.email as customer_email,
            c.address as customer_address,
            u.username as created_by_name
        FROM quotations q
        LEFT JOIN customers c ON q.customer_id = c.id
        JOIN users u ON q.created_by = u.id
        WHERE q.id = ?
    ");
    $stmt->execute([$quotation_id]);
    $quotation = $stmt->fetch();
    
    if (!$quotation) {
        throw new Exception('Quotation not found');
    }
    
    // Get quotation items
    $stmt = $pdo->prepare("
        SELECT 
            qi.*,
            p.name as product_name,
            p.price as product_current_price
        FROM quotation_items qi
        JOIN products p ON qi.product_id = p.id
        WHERE qi.quotation_id = ?
        ORDER BY qi.id ASC
    ");
    $stmt->execute([$quotation_id]);
    $items = $stmt->fetchAll();
    
    // Calculate totals
    $subtotal = 0;
    foreach ($items as $item) {
        $subtotal += $item['total_price'];
    }
    
    echo json_encode([
        'success' => true,
        'quotation' => $quotation,
        'items' => $items,
        'subtotal' => $subtotal
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 